/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MergeManyValues;

public class MergeManyValuesTest
extends AbstractFilterTest {
    public MergeManyValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        MergeManyValues f = new MergeManyValues();
        f.setAttributeIndex("2");
        return f;
    }

    public void testInvalidAttributeTypes() {
        Instances icopy = new Instances(this.m_Instances);
        try {
            ((MergeManyValues)this.m_Filter).setAttributeIndex("1");
            this.m_Filter.setInputFormat(icopy);
            MergeManyValuesTest.fail("Should have thrown an exception selecting a STRING attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((MergeManyValues)this.m_Filter).setAttributeIndex("3");
            this.m_Filter.setInputFormat(icopy);
            MergeManyValuesTest.fail("Should have thrown an exception indicating a NUMERIC attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testTypical() {
        Instances result = this.useFilter();
        MergeManyValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeManyValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int mergedIndex = -1;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Instances.instance(i).value(1) == 0.0 || this.m_Instances.instance(i).value(1) == 1.0) {
                if (mergedIndex == -1) {
                    mergedIndex = (int)result.instance(i).value(1);
                } else {
                    MergeManyValuesTest.assertEquals("Checking merged value for instance: " + (i + 1), mergedIndex, (int)result.instance(i).value(1));
                }
            }
            ++i;
        }
    }

    public void testDifferentRange() {
        ((MergeManyValues)this.m_Filter).setMergeValueRange("2,3");
        Instances result = this.useFilter();
        MergeManyValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeManyValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int mergedIndex = -1;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Instances.instance(i).value(1) == 1.0 || this.m_Instances.instance(i).value(1) == 2.0) {
                if (mergedIndex == -1) {
                    mergedIndex = (int)result.instance(i).value(1);
                } else {
                    MergeManyValuesTest.assertEquals("Checking merged value for instance: " + (i + 1), mergedIndex, (int)result.instance(i).value(1));
                }
            }
            ++i;
        }
    }

    public void testMergeAll() {
        ((MergeManyValues)this.m_Filter).setMergeValueRange("first-last");
        Instances result = this.useFilter();
        MergeManyValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeManyValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        MergeManyValuesTest.assertEquals(1, result.attribute(1).numValues());
    }

    public void testAttributeWithMissing() {
        ((MergeManyValues)this.m_Filter).setAttributeIndex("5");
        ((MergeManyValues)this.m_Filter).setMergeValueRange("1,2");
        Instances result = this.useFilter();
        MergeManyValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        MergeManyValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int mergedIndex = -1;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Instances.instance(i).isMissing(4)) {
                MergeManyValuesTest.assertTrue("Missing in input should give missing in result", result.instance(i).isMissing(4));
            } else if (this.m_Instances.instance(i).value(4) == 0.0 || this.m_Instances.instance(i).value(4) == 1.0) {
                if (mergedIndex == -1) {
                    mergedIndex = (int)result.instance(i).value(4);
                } else {
                    MergeManyValuesTest.assertEquals("Checking merged value for instance: " + (i + 1), mergedIndex, (int)result.instance(i).value(4));
                }
            }
            ++i;
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isNominal()) {
                    ((MergeManyValues)this.m_FilteredClassifier.getFilter()).setAttributeIndex("" + (i + 1));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            MergeManyValuesTest.fail("Problem setting up test for FilteredClassifier: " + e.toString());
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(MergeManyValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(MergeManyValuesTest.suite());
    }
}

